import java.net.*;
import java.util.*;
import java.io.*;

public class TimeServer {
	public static void main(String[] args) {
		try {
			// setup variables now for efficiency later
			DatagramSocket socket = new DatagramSocket(4445);
			byte[] buf = new byte[8];

			DatagramPacket packet = null;
			InetAddress address = null;
			int port = 0;
			
			ByteArrayOutputStream baos = null;
			DataOutputStream packetOut = null;
			
			while(true) {
				// construct structures for return packet now for later efficiency
				baos = new ByteArrayOutputStream();
				packetOut = new DataOutputStream(baos);

				// construct packet to receive (empty)
				packet = new DatagramPacket(buf, buf.length);
				socket.receive(packet);
				address = packet.getAddress();
				port = packet.getPort();
				
				// write and send return packet
				packetOut.writeLong(new Date().getTime());
				packet = new DatagramPacket(baos.toByteArray(), baos.size(), address, port);
				socket.send(packet);
			}
		} catch(Exception e) {
			System.out.println("Error: " + e.toString());
		}
	}	
}