import java.net.*;
import java.util.*;
import java.io.*;

public class TimeClient {
	public static void main(String[] args) {
		try {
			// initialize variables to save time later
			DatagramSocket socket = new DatagramSocket();
			byte[] sendBuf = new byte[1];
			byte[] buf = new byte[8];

			DatagramPacket sendPacket = null;
			DatagramPacket recPacket = null;
			InetAddress address = InetAddress.getByName(args[0]);
			int port = 0;
			Date recTime = null;
			Date sendTime = null;
			BufferedWriter out = new BufferedWriter(new FileWriter("diffs.txt"));
			
			Date repeatDate = new Date();
			
			for(int i = 0; i < 120; i++) {
				// ensure that sleep is not just for one minute, but for the remaining time between
				// when we get here and one minute after our last measurement. Simply adding one
				// minute to the current time will result in a gradual drift, making the resulting
				// fitting incorrect
				Thread.sleep(repeatDate.getTime() + (60000 * (i + 1)) - new Date().getTime());
				
				// construct the packet to send
				sendPacket = new DatagramPacket(sendBuf, sendBuf.length, address, 4445);
				recPacket = new DatagramPacket(buf, buf.length);
				
				// get the time just before sending
				sendTime = new Date();
				socket.send(sendPacket);
				socket.receive(recPacket);
				// get the time again as soon as reception is complete before doing anything else
				recTime = new Date();
				
				// read data from packet
				DataInputStream packetIn = new DataInputStream(new ByteArrayInputStream(recPacket.getData()));
				long received = packetIn.readLong();
				
				// calculate timing information
				float split = ((float) (recTime.getTime() - sendTime.getTime()))/2.0f;
				float diff = ((float) (recTime.getTime() - received)) - split;
				
				// write timing information to file
				out.write(Float.toString(diff));
				out.newLine();
			}
			
			out.close();
		} catch(Exception e) {
			System.out.println("Error: " + e.toString());
		}
	}
}